<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Option Templates for Magento 2
 */

namespace Amasty\Prot\Plugin\Catalog\Model\Product\Option;

use Amasty\Prot\Api\Data\TemplateOptionValueInterface;
use Magento\Catalog\Model\Product\Option\Value;
use Magento\Framework\Registry;

class ValuePlugin
{
    /**
     * @var Registry
     */
    private $registry;

    public function __construct(
        Registry $registry
    ) {
        $this->registry = $registry;
    }

    /**
     * @param Value $optionValue
     * @return Value
     */
    public function afterAfterSave(Value $optionValue)
    {
        if ($optionValue->hasData(TemplateOptionValueInterface::DATA_IDENTIFIER)) {
            $optionValuesRelations = $this->registry->registry(TemplateOptionValueInterface::DATA_IDENTIFIER) ?: [];
            $optionValuesRelations[$optionValue->getId()] = [
                TemplateOptionValueInterface::ID => $optionValue->getData(
                    TemplateOptionValueInterface::DATA_IDENTIFIER
                ),
                TemplateOptionValueInterface::SWATCH_VALUE => $optionValue->getData(
                    TemplateOptionValueInterface::SWATCH_VALUE
                )
            ];
            $this->registry->unregister(TemplateOptionValueInterface::DATA_IDENTIFIER);
            $this->registry->register(TemplateOptionValueInterface::DATA_IDENTIFIER, $optionValuesRelations);
        }

        return $optionValue;
    }
}
