<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Option Templates for Magento 2
 */

namespace Amasty\Prot\Plugin\Catalog\Model\Product\Option;

use Magento\Catalog\Model\Product\Option\SaveHandler;

class SaveHandlerPlugin
{
    public const EXCLUDE_AMASTY_TEMPLATE_OPTIONS = 'exclude_amasty_template_options';

    /**
     * @param SaveHandler $subject
     * @param $entity
     * @param array $arguments
     *
     * @return array
     */
    public function beforeExecute($subject, $entity, $arguments = [])
    {
        $entity->setData(self::EXCLUDE_AMASTY_TEMPLATE_OPTIONS, true);
        return [$entity, $arguments];
    }
}
