<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Option Templates for Magento 2
 */

namespace Amasty\Prot\Plugin\Catalog\Model\Product\Option\Repository;

use Amasty\Prot\Model\Repository\Template as TemplateRepository;
use Amasty\Prot\Model\ResourceModel\Catalog\Product\Option\DuplicateMagentoOptions;
use Closure;
use Exception;
use Magento\Catalog\Api\Data\ProductInterface;
use Magento\Catalog\Model\Product;
use Magento\Catalog\Model\Product\Option\Repository;
use Magento\Framework\EntityManager\MetadataPool;
use Magento\Framework\Exception\LocalizedException;
use Zend_Db_Statement_Exception;

class SaveOptionsOnDuplicate
{
    /**
     * @var TemplateRepository
     */
    private $templateRepository;

    /**
     * @var DuplicateMagentoOptions
     */
    private $duplicateMagentoOptions;

    /**
     * @var MetadataPool
     */
    private $metadataPool;

    public function __construct(
        DuplicateMagentoOptions $duplicateMagentoOptions,
        TemplateRepository $templateRepository,
        MetadataPool $metadataPool
    ) {
        $this->templateRepository = $templateRepository;
        $this->duplicateMagentoOptions = $duplicateMagentoOptions;
        $this->metadataPool = $metadataPool;
    }

    /**
     * @param Repository $subject
     * @param Closure $proceed
     * @param ProductInterface|Product $product
     * @param ProductInterface|Product $duplicate
     * @return mixed|void
     * @throws LocalizedException
     * @throws Zend_Db_Statement_Exception
     * @throws Exception
     */
    public function aroundDuplicate(
        Repository $subject,
        Closure $proceed,
        ProductInterface $product,
        ProductInterface $duplicate
    ) {
        $templates = $product->getTemplates();
        if ($templates) {
            $metadata = $this->metadataPool->getMetadata(ProductInterface::class);
            $linkField = $metadata->getLinkField();

            // use our class for duplicate magento options
            // because magento clone our options
            $this->duplicateMagentoOptions->execute(
                (int) $product->getData($linkField),
                (int) $duplicate->getData($linkField)
            );
            foreach ($templates as $template) {
                $ids = [$duplicate->getId()];
                $this->templateRepository->assignTemplateToIds((int) $template['template_id'], $ids);
            }
        } else {
            return $proceed($product, $duplicate);
        }
    }
}
