<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Option Templates for Magento 2
 */

namespace Amasty\Prot\Model\ResourceModel\TemplateOptionValue;

use Amasty\Prot\Api\Data\TemplateOptionValueInterface;
use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;

class Collection extends AbstractCollection
{
    /**
     * Define resource model
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_setIdFieldName(TemplateOptionValueInterface::ID);
        $this->_init(
            \Amasty\Prot\Model\TemplateOptionValue::class,
            \Amasty\Prot\Model\ResourceModel\TemplateOptionValue::class
        );
    }
}
