<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Option Templates for Magento 2
 */

namespace Amasty\Prot\Model\ResourceModel;

use Amasty\Prot\Api\Data\TemplateOptionValueInterface;
use Magento\Framework\Model\AbstractModel;
use Magento\Framework\Model\ResourceModel\Db\AbstractDb;

class TemplateOptionValue extends AbstractDb
{
    public const PRODUCT_OPTION_VALUE_FIELD = 'catalog_product_option_value_id';

    /**
     * Model Initialization
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init(TemplateOptionValueInterface::MAIN_TABLE, TemplateOptionValueInterface::ID);
    }

    /**
     * @param AbstractModel|TemplateOptionValueInterface $object
     * @return AbstractDb
     */
    protected function _afterSave(AbstractModel $object)
    {
        if ($object->getOptionValueId()) {
            $insertData = [
                TemplateOptionValueInterface::RELATION_TEMPLATE_VALUE_ID => $object->getId(),
                TemplateOptionValueInterface::RELATION_VALUE_ID => $object->getOptionValueId(),
            ];
            $this->getConnection()->insertOnDuplicate(
                $this->getTable(TemplateOptionValueInterface::RELATION_TABLE),
                $insertData
            );
        }

        return parent::_afterSave($object);
    }
}
