<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Option Templates for Magento 2
 */

namespace Amasty\Prot\Model\ResourceModel\Catalog;

class Product extends \Magento\Catalog\Model\ResourceModel\Product
{
    /**
     * @param int $origId
     * @param array $productIds
     * @param string $linkField
     */
    public function updateEntityOptionsValues(int $origId, array $productIds, string $linkField)
    {
        $connection = $this->getConnection();
        $connection->update(
            $this->getTable($this->getEntityTable()),
            ['has_options' => 1],
            $connection->quoteInto($linkField . ' IN(?)', $productIds)
        );
    }
}
