<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Option Templates for Magento 2
 */

namespace Amasty\Prot\Model\Catalog\Locator;

class LocatorFactory
{
    /**
     * @var \Magento\Framework\ObjectManagerInterface
     */
    private $_objectManager;

    /**
     * Factory constructor
     *
     * @param \Magento\Framework\ObjectManagerInterface $objectManager
     */
    public function __construct(\Magento\Framework\ObjectManagerInterface $objectManager)
    {
        $this->_objectManager = $objectManager;
    }

    /**
     * Create class instance with specified parameters
     *
     * @param array $data
     * @return \Amasty\Prot\Model\ResourceModel\Template\Collection
     */
    public function create(array $data = [])
    {
        return $this->_objectManager->create($this->getInstanceName(), $data);
    }

    /**
     * @return string
     */
    protected function getInstanceName()
    {
        if (class_exists((\Magento\CatalogStaging\Model\Product\Locator\StagingLocator::class))) {
            $instanceName = \Magento\CatalogStaging\Model\Product\Locator\StagingLocator::class;
        } else {
            $instanceName = \Magento\Catalog\Model\Locator\RegistryLocator::class;
        }

        return $instanceName;
    }
}
