<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Option Templates for Magento 2
 */

namespace Amasty\Prot\Controller\Adminhtml\Templates;

use Amasty\Prot\Controller\Adminhtml\Templates;
use Magento\Backend\App\Action;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Controller\ResultInterface;

class Index extends Templates
{
    /**
     * @var \Magento\Cron\Model\ResourceModel\Schedule\CollectionFactory
     */
    private $collectionFactory;

    public function __construct(
        Action\Context $context,
        \Magento\Cron\Model\ResourceModel\Schedule\CollectionFactory $collectionFactory
    ) {
        parent::__construct($context);
        $this->collectionFactory = $collectionFactory;
    }

    /**
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\ResultInterface|void
     */
    public function execute()
    {
        $resultPage = $this->resultFactory->create(ResultFactory::TYPE_PAGE);
        $response = $this->getResponse();
        $this->checkCronConfiguration();
        $this->initAction($resultPage);
        $resultPage->getConfig()->getTitle()->prepend(__('Template List'));
        $resultPage->renderResult($response);
    }

    private function initAction(ResultInterface $resultPage): void
    {
        $resultPage->setActiveMenu(self::ADMIN_RESOURCE);
        $resultPage->addBreadcrumb(__('Template List'), __('Template List'));
    }

    protected function checkCronConfiguration()
    {
        $scheduleCollection = $this->getScheduledCollection();
        if ($scheduleCollection->getSize() == 0) {
            $this->messageManager->addNoticeMessage(
                __('No cron job "amprot_schedule" found. Please check your cron configuration.')
            );
        }

        $scheduleCollection = $this->getScheduledRunCollection();
        if ($scheduleCollection->getSize() !== 0) {
            $this->messageManager->addNoticeMessage(
                __('Cron job "amprot_schedule" is still running. Please delete it and check your error log.')
            );
        }
    }

    /**
     * @return \Magento\Cron\Model\ResourceModel\Schedule\Collection
     */
    protected function getScheduledCollection()
    {
        $scheduleCollection = $this->collectionFactory->create()
            ->addFieldToFilter('job_code', ['eq' => 'amprot_schedule']);
        $scheduleCollection->getSelect()->order('schedule_id desc');

        return $scheduleCollection;
    }

    /**
     * @return \Magento\Cron\Model\ResourceModel\Schedule\Collection
     */
    protected function getScheduledRunCollection()
    {
        $scheduleCollection = $this->getScheduledCollection()
            ->addFieldToFilter('status', ['eq' => 'running'])
            ->addFieldToFilter('executed_at', ['lteq' => new \Zend_Db_Expr('NOW() - INTERVAL 1 DAY')]);

        return $scheduleCollection;
    }
}
