<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Option Templates for Magento 2
 */

namespace Amasty\Prot\Controller\Adminhtml\Templates;

use Amasty\Prot\Api\TemplateRepositoryInterface;
use Amasty\Prot\Controller\Adminhtml\Templates;
use Magento\Backend\App\Action;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\Exception\NoSuchEntityException;

class Edit extends Templates
{
    /**
     * @var TemplateRepositoryInterface
     */
    private $templateRepository;

    /**
     * @var \Amasty\Prot\Model\Catalog\Locator\RegistryLocator
     */
    private $registryLocator;

    /**
     * @var \Magento\Catalog\Api\Data\ProductInterfaceFactory
     */
    private $productFactory;

    public function __construct(
        Action\Context $context,
        \Amasty\Prot\Api\TemplateRepositoryInterface $templateRepository,
        \Amasty\Prot\Model\Catalog\Locator\RegistryLocator $registryLocator,
        \Magento\Catalog\Api\Data\ProductInterfaceFactory $productFactory
    ) {
        parent::__construct($context);
        $this->templateRepository = $templateRepository;
        $this->registryLocator = $registryLocator;
        $this->productFactory = $productFactory;
    }

    /**
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\ResultInterface|void
     */
    public function execute()
    {
        $templateId = (int)$this->getRequest()->getParam('id');
        if ($templateId) {
            try {
                $this->templateRepository->get($templateId);
            } catch (NoSuchEntityException $exception) {
                $this->messageManager->addErrorMessage(__('This template no longer exists.'));
                $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);

                return $resultRedirect->setPath('*/*/index');
            }
        }

        $product = $this->productFactory->create();
        $product->setTypeId('simple');
        $product->setStoreId(0);
        $this->registryLocator->setProduct($product);
        $resultPage = $this->resultFactory->create(ResultFactory::TYPE_PAGE);
        $response = $this->getResponse();
        $this->initAction($resultPage, $templateId);

        // set title and breadcrumbs
        $resultPage->getConfig()->getTitle()->prepend(__('Manage Template'));
        $resultPage->getConfig()->getTitle()->prepend(
            $templateId ?
                __('Edit Template # %1', $templateId)
                : __('New Template')
        );
        $resultPage->renderResult($response);
    }

    private function initAction(ResultInterface $resultPage, int $templateId): void
    {
        $breadcrumb = $templateId ? __('EditTemplate # %1', $templateId) : __('New Template');
        $resultPage->setActiveMenu(self::ADMIN_RESOURCE);
        $resultPage->addBreadcrumb($breadcrumb, $breadcrumb);
    }
}
