<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Option Templates for Magento 2
 */

namespace Amasty\Prot\Api\Data;

interface TemplateOptionValueInterface
{
    public const MAIN_TABLE = 'amasty_prot_template_option_value';

    public const ID = 'id';
    public const TEMPLATE_OPTION_ID = 'template_option_id';
    public const SWATCH_VALUE = 'swatch_value';

    public const DATA_IDENTIFIER = 'template_option_value_id';

    public const RELATION_TABLE = 'amasty_prot_option_value_relation';
    public const RELATION_VALUE_ID = 'value_id';
    public const RELATION_TEMPLATE_VALUE_ID = 'parent_value_id';

    /**
     * @return int
     */
    public function getId();

    /**
     * @param int $id
     *
     * @return \Amasty\Prot\Api\Data\TemplateOptionValueInterface
     */
    public function setId($id);

    /**
     * @return int
     */
    public function getTemplateOptionId();

    /**
     * @param int $templateOptionId
     *
     * @return \Amasty\Prot\Api\Data\TemplateOptionValueInterface
     */
    public function setTemplateOptionId($templateOptionId);

    /**
     * @return int
     */
    public function getOptionValueId();

    /**
     * @param int $optionValueId
     *
     * @return \Amasty\Prot\Api\Data\TemplateOptionValueInterface
     */
    public function setOptionValueId($optionValueId);

    /**
     * @return string
     */
    public function getSwatchValue();

    /**
     * @param string $swatchvalue
     *
     * @return \Amasty\Prot\Api\Data\TemplateOptionValueInterface
     */
    public function setSwatchValue($swatchvalue);
}
