<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Option Templates for Magento 2
 */

namespace Amasty\Prot\Api\Data;

/**
 * @api
 */
interface TemplateOptionInterface
{
    /**#@+
     * Constants defined for keys of data array
     */
    public const MAIN_TABLE = 'amasty_prot_template_option';
    public const RELATION_TABLE = 'amasty_prot_option_relation';
    public const OPTION_ID = 'option_id';
    public const TEMPLATE_ID = 'template_id';
    public const DEPENDENCY = 'dependency';
    public const FONT_COLOR = 'font_color';
    public const FONT_SIZE = 'font_size';
    public const PARENT_OPTION_ID = 'parent_option_id';
    public const RELATION_OPTION_ID = 'option_id';
    public const OPTIONS_LIST_TYPE = 'option_list_type';
    public const USE_SWATCHES = 'use_swatches';
    /**#@-*/

    /**
     * @return int
     */
    public function getOptionId();

    /**
     * @param int $optionId
     *
     * @return TemplateOptionInterface
     */
    public function setOptionId($optionId);

    /**
     * @return int
     */
    public function getTemplateId();

    /**
     * @param int $templateId
     *
     * @return TemplateOptionInterface
     */
    public function setTemplateId($templateId);

    /**
     * @return string
     */
    public function getDependency();

    /**
     * @param string $dependency
     *
     * @return TemplateOptionInterface
     */
    public function setDependency($dependency);

    /**
     * @return string
     */
    public function getFontColor();

    /**
     * @param string $color
     *
     * @return TemplateOptionInterface
     */
    public function setFontColor($color);

    /**
     * @return int
     */
    public function getFontSize();

    /**
     * @param int $size
     *
     * @return TemplateOptionInterface
     */
    public function setFontSize($size);

    /**
     * @return int
     */
    public function getOptionListType();

    /**
     * @param int $type
     *
     * @return TemplateOptionInterface
     */
    public function setOptionListType($type);

    /**
     * @return int
     */
    public function getUseSwatches();

    /**
     * @param int $value
     *
     * @return TemplateOptionInterface
     */
    public function setUseSwatches($value);
}
