<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Option Templates for Magento 2
 */

namespace Amasty\Prot\Api\Data;

/**
 * @api
 */
interface ScheduleInterface
{
    /**#@+
     * Constants defined for keys of data array
     */
    public const MAIN_TABLE = 'amasty_prot_schedule';

    public const SCHEDULE_ID = 'schedule_id';
    public const AMASTY_OPTION_ID = 'amasty_option_id';
    public const ORIGINAL_PRODUCT_ID = 'original_product_id';
    public const PRODUCT_ID = 'product_id';
    public const CREATED_AT = 'created_at';
    public const BATCH_SIZE = 100;

    /**#@-*/

    /**
     * @return int
     */
    public function getScheduleId();

    /**
     * @param int $scheduleId
     *
     * @return ScheduleInterface
     */
    public function setScheduleId($scheduleId);

    /**
     * @return int
     */
    public function getAmastyOptionId();

    /**
     * @param int $optionId
     *
     * @return ScheduleInterface
     */
    public function setAmastyOptionId($optionId);

    /**
     * @return int
     */
    public function getOriginalProductId();

    /**
     * @param int $productId
     *
     * @return ScheduleInterface
     */
    public function setOriginalProductId($productId);

    /**
     * @return int
     */
    public function getProductId();

    /**
     * @param int $productId
     *
     * @return ScheduleInterface
     */
    public function setProductId($productId);
}
