<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Labels GraphQL for Magento 2 (System)
 */

use Amasty\Label\Api\LabelRepositoryInterface;
use Amasty\Label\Model\Indexer\IndexBuilder;
use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\Workaround\Override\Fixture\Resolver;

$objectManager = Bootstrap::getObjectManager();

/** @var LabelRepositoryInterface $labelRepository */
$labelRepository = $objectManager->get(LabelRepositoryInterface::class);

/** @var SearchCriteriaBuilder $searchCriteria */
$searchCriteria = Bootstrap::getObjectManager()->create(SearchCriteriaBuilder::class);

/** @var IndexBuilder $indexBuilder */
$indexBuilder = $objectManager->get(IndexBuilder::class);

$searchCriteriaLabel = $searchCriteria
    ->addFilter('name', 'Amasty Test Label')
    ->addFilter('status', 1)
    ->create();
$labels = $labelRepository->getList($searchCriteriaLabel)->getItems();

foreach ($labels as $label) {
    $labelRepository->deleteById($label->getLabelId());
}

Resolver::getInstance()->requireDataFixture('Magento/GraphQl/Catalog/_files/simple_product_rollback.php');
Resolver::getInstance()->requireDataFixture('Magento/GraphQl/Catalog/_files/virtual_product_rollback.php');

$indexBuilder->reindexFull();
