<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Labels GraphQL for Magento 2 (System)
 */

use Amasty\Label\Api\Data\LabelExtensionFactory;
use Amasty\Label\Api\Data\LabelFrontendSettingsInterface;
use Amasty\Label\Api\Data\LabelInterface;
use Amasty\Label\Api\Data\LabelTooltipInterface;
use Amasty\Label\Api\LabelRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\Workaround\Override\Fixture\Resolver;

Resolver::getInstance()->requireDataFixture('Magento/GraphQl/Catalog/_files/simple_product.php');
Resolver::getInstance()->requireDataFixture('Magento/GraphQl/Catalog/_files/virtual_product.php');

$objectManager = Bootstrap::getObjectManager();

/** @var LabelRepositoryInterface $labelRepository */
$labelRepository = $objectManager->get(LabelRepositoryInterface::class);

/** @var LabelInterface $label */
$label = $objectManager->get(LabelInterface::class);

/** @var LabelTooltipInterface $labelTooltip */
$labelTooltip = $objectManager->get(LabelTooltipInterface::class);

/** @var LabelFrontendSettingsInterface $labelFrontSetting */
$labelFrontSetting = $objectManager->create(LabelFrontendSettingsInterface::class);

/** @var LabelExtensionFactory $labelExtensionFactory */
$labelExtensionFactory = $objectManager->get(LabelExtensionFactory::class);

// create extension attributes for product view
$labelTooltip->setStatus(1);

$labelFrontSetting->setType(2);
$labelFrontSetting->setLabelText('am_label_product_text {PRICE}');
$labelFrontSetting->setRedirectUrl('am_label_red_url_product');
$labelFrontSetting->setPosition(3);
$labelFrontSetting->setStyle('font-size: 12px;');
$labelFrontSetting->setAltTag('am_alt_prod_tag');

$labelExtension = $labelExtensionFactory->create();
$labelExtension->setLabelTooltip($labelTooltip);
$labelExtension->setFrontendSettings($labelFrontSetting);

// create label and set values
$condition = [
    'type' => Amasty\Label\Model\Rule\Condition\Combine::class,
    'attribute' => null,
    'operator' => null,
    'value' => '1',
    'is_value_processed' => null,
    'aggregator' => 'all',
    'conditions' => [
        (object)[
            'type' => Magento\CatalogRule\Model\Rule\Condition\Product::class,
            'attribute' => 'sku',
            'operator' => '()',
            'value' => 'simple_product,virtual_product',
            'is_value_processed' => false,
        ]
    ]
];

$label->setName('Amasty Test Label');
$label->setStatus(1);
$label->setPriority(0);
$label->setIsSingle(false);
$label->setUseForParent(false);
$label->setConditionSerialized(json_encode($condition));
$label->setCustomerGroupIds([32000]);
$label->setStores([0]);
$label->setExtensionAttributes($labelExtension);

// save label for product view
$labelRepository->save($label);

// create extension attribute for category view
$labelFrontSetting = $objectManager->create(LabelFrontendSettingsInterface::class);
$labelFrontSetting->setType(1);
$labelFrontSetting->setLabelText('am_label_category_text {SKU}');
$labelFrontSetting->setRedirectUrl('am_label_red_url_category');
$labelFrontSetting->setPosition(8);
$labelFrontSetting->setStyle('font-size: 13px;');
$labelFrontSetting->setAltTag('am_alt_cat_tag');

// get created label id and set additional extension attribute
$label = $labelRepository->getById($label->getLabelId());

$labelExtension = $labelExtensionFactory->create();
$labelExtension->setFrontendSettings($labelFrontSetting);

$label->setExtensionAttributes($labelExtension);

// save label for category view
$labelRepository->save($label);
