<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Labels GraphQL for Magento 2 (System)
 */

namespace Amasty\LabelGraphQl\Test\GraphQl;

use Magento\TestFramework\TestCase\GraphQlAbstract;

class GetAmLabelSettingTest extends GraphQlAbstract
{
    private const MAIN_RESPONSE_KEY = 'amLabelSetting';

    /**
     * @group amasty_label
     *
     * @magentoConfigFixture base_website amasty_label/display/category .product-image-container
     * @magentoConfigFixture base_website amasty_label/display/product #amasty-main-container
     * @magentoConfigFixture base_website amasty_label/display/max_labels 5
     * @magentoConfigFixture base_website amasty_label/display/show_several_on_place 0
     * @magentoConfigFixture base_website amasty_label/display/labels_alignment 1
     * @magentoConfigFixture base_website amasty_label/display/margin_between 20
     */
    public function testAmLabelSetting(): void
    {
        $assertArray = [
            'category_container' => '.product-image-container',
            'labels_alignment' => 1,
            'margin_between' => 20,
            'max_labels' => 5,
            'product_container' => '#amasty-main-container',
            'show_several_on_place' => 0
        ];

        $response = $this->graphQlQuery($this->getQuery());

        $this->assertArrayHasKey(self::MAIN_RESPONSE_KEY, $response);
        $this->assertResponseFields($response[self::MAIN_RESPONSE_KEY], $assertArray);
    }

    private function getQuery(): string
    {
        return <<<QUERY
query {
    amLabelSetting {
        category_container
        labels_alignment
        margin_between
        max_labels
        product_container
        show_several_on_place
    }
}
QUERY;
    }
}
