<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package API for Product Attachments (Add-On) for Magento 2
 */

namespace Amasty\ProductAttachmentApi\Model;

use Amasty\ProductAttachment\Model\Filesystem\Directory;
use Amasty\ProductAttachment\Model\Filesystem\FileUploader;
use Amasty\ProductAttachment\Model\Icon\ResourceModel\Icon;
use Amasty\ProductAttachmentApi\Api\UploadFileInterface;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Filesystem;

class UploadFile implements UploadFileInterface
{
    /**
     * @var Filesystem\Directory\WriteInterface
     */
    private $mediaDirectory;

    public function __construct(
        Filesystem $filesystem
    ) {
        $this->mediaDirectory = $filesystem->getDirectoryWrite(
            DirectoryList::MEDIA
        );
    }

    /**
     * @inheritdoc
     */
    public function upload(\Amasty\ProductAttachmentApi\Api\Data\FileContentInterface $fileContent)
    {
        //phpcs:ignore
        if (!($file = base64_decode($fileContent->getBase64EncodedData()))) {
            throw new LocalizedException(__('Base64Decode File Error'));
        }
        $path = $this->mediaDirectory->getAbsolutePath(Directory::DIRECTORY_CODES[Directory::TMP_DIRECTORY]);
        $name = $fileContent->getNameWithExtension();

        if (!$this->mediaDirectory->isExist(Directory::DIRECTORY_CODES[Directory::TMP_DIRECTORY])) {
            $this->mediaDirectory->create(Directory::DIRECTORY_CODES[Directory::TMP_DIRECTORY]);
        }
        $this->mediaDirectory->getDriver()->filePutContents(
            $path . DIRECTORY_SEPARATOR . $name,
            $file
        );

        $fileContent->setBase64EncodedData(null);
        $fileContent->setNameWithExtension(null);
        $fileContent->setTemporaryName($name);

        return $fileContent;
    }
}
