<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package API for Product Attachments (Add-On) for Magento 2
 */

namespace Amasty\ProductAttachmentApi\Model\File\Type;

use Amasty\ProductAttachmentApi\Model\File\Type\Processor\TypeProcessorInterface;

class TypeProcessorProvider
{
    /**
     * @var TypeProcessorInterface[]
     */
    private $processors;

    /**
     * @param array $fileTypes [ 'file_type' => ['typeCode' => 0, 'processor' => TypeProcessorInterface] ]
     */
    public function __construct(
        array $fileTypes = []
    ) {
        $this->initializeFileTypes($fileTypes);
    }

    public function getProcessorByType(int $type): TypeProcessorInterface
    {
        return $this->processors[$type];
    }

    private function initializeFileTypes(array $fileTypes): void
    {
        foreach ($fileTypes as $fileType) {
            if (!$fileType['processor'] instanceof TypeProcessorInterface) {
                throw new \LogicException(
                    sprintf('File type must implement %s', TypeProcessorInterface::class)
                );
            }
            $this->processors[$fileType['typeCode']] = $fileType['processor'];
        }
    }
}
