<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package API for Product Attachments (Add-On) for Magento 2
 */

namespace Amasty\ProductAttachmentApi\Model\File\Type\Processor;

use Amasty\ProductAttachment\Api\Data\FileInterface;
use Amasty\ProductAttachment\Controller\Adminhtml\RegistryConstants;
use Amasty\ProductAttachment\Model\ConfigProvider;
use Amasty\ProductAttachment\Model\File\FileType\FrontendUrlGenerator;
use Magento\Framework\Url;
use Magento\Store\Model\StoreManagerInterface;

class Link implements TypeProcessorInterface
{
    /**
     * @var Url
     */
    private $urlBuilder;

    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    /**
     * @var FrontendUrlGenerator
     */
    private $frontendUrlGenerator;

    public function __construct(
        Url $urlBuilder,
        StoreManagerInterface $storeManager,
        ConfigProvider $configProvider,
        FrontendUrlGenerator $frontendUrlGenerator
    ) {
        $this->urlBuilder = $urlBuilder;
        $this->storeManager = $storeManager;
        $this->configProvider = $configProvider;
        $this->frontendUrlGenerator = $frontendUrlGenerator;
    }

    public function addFrontendUrl(FileInterface $file): void
    {
        $params[RegistryConstants::STORE] = $this->storeManager->getStore()->getId();
        $this->frontendUrlGenerator->addUrl($file, $params);
    }
}
