<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package API for Product Attachments (Add-On) for Magento 2
 */

namespace Amasty\ProductAttachmentApi\Model\File\Type\Processor;

use Amasty\ProductAttachment\Api\Data\FileInterface;
use Amasty\ProductAttachment\Model\Filesystem\Directory;
use Magento\Store\Model\StoreManagerInterface;

class File implements TypeProcessorInterface
{
    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    public function __construct(
        StoreManagerInterface $storeManager
    ) {
        $this->storeManager = $storeManager;
    }

    public function addFrontendUrl(FileInterface $file): void
    {
        $file->setFrontendUrl($this->storeManager->getStore()->getBaseUrl()
            . 'pub' . DIRECTORY_SEPARATOR . 'media' . DIRECTORY_SEPARATOR
            . Directory::DIRECTORY_CODES[Directory::ATTACHMENT]
            . DIRECTORY_SEPARATOR . $file->getFilePath());
    }
}
