<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package API for Product Attachments (Add-On) for Magento 2
 */

namespace Amasty\ProductAttachmentApi\Api;

interface DownloadFileInterface
{
    /**
     * Download File
     *
     * @param int $fileId
     * @param int $productId
     * @param int $categoryId
     * @param int $amastyCustomerGroup
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     * @return \Amasty\ProductAttachmentApi\Api\Data\FileContentInterface
     */
    public function download($fileId, $productId = 0, $categoryId = 0, $amastyCustomerGroup = 0);
}
