<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package API for Product Attachments (Add-On) for Magento 2
 */

namespace Amasty\ProductAttachmentApi\Api\Data;

interface FileContentInterface
{
    public const BASE64_ENCODED_DATA = 'base64_encoded_data';
    public const NAME = 'name_with_extension';
    public const TMP_NAME = 'temporary_name';

    /**
     * @return string
     */
    public function getBase64EncodedData();

    /**
     * @param string $base64EncodedData
     *
     * @return FileContentInterface
     */
    public function setBase64EncodedData($base64EncodedData);

    /**
     * @param string $nameWithExtension
     *
     * @return FileContentInterface
     */
    public function setNameWithExtension($nameWithExtension);

    /**
     * @return string
     */
    public function getNameWithExtension();

    /**
     * @return string|null
     */
    public function getTemporaryName();
}
