<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package API for Product Attachments (Add-On) for Magento 2
 */

namespace Amasty\ProductAttachmentApi\Api\Data;

interface BackendFileInterface extends \Amasty\ProductAttachment\Api\Data\FileInterface
{
    /**#@+
     * Constants defined for keys of data array
     */
    public const ATTACHMENT_PRODUCTS = 'attachment_products';
    public const ATTACHMENT_CATEGORIES = 'attachment_categories';
    public const TMP_FILE = 'tmp_file';
    /**#@-*/

    /**
     * @return string[]
     */
    public function getAttachmentProducts();

    /**
     * @param string[] $products
     *
     * @return \Amasty\ProductAttachmentApi\Api\Data\BackendFileInterface
     */
    public function setAttachmentProducts($products);

    /**
     * @return string[]
     */
    public function getAttachmentCategories();

    /**
     * @param string[] $categories
     *
     * @return \Amasty\ProductAttachmentApi\Api\Data\BackendFileInterface
     */
    public function setAttachmentCategories($categories);

    /**
     * @return string
     */
    public function getTmpFile();

    /**
     * @param string $tmpFile
     *
     * @return \Amasty\ProductAttachmentApi\Api\Data\BackendFileInterface
     */
    public function setTmpFile($tmpFile);
}
