<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Pre Order Base for Magento 2
 */

namespace Amasty\Preorder\Plugin\Catalog\Block\Product\ListProduct;

use Amasty\Preorder\Plugin\ProductList\GetPreorderHtmlForList;
use Magento\Catalog\Block\Product\ListProduct;

class AddPreorderHtml
{
    /**
     * @var GetPreorderHtmlForList
     */
    private $getPreorderHtmlForList;

    public function __construct(GetPreorderHtmlForList $getPreorderHtmlForList)
    {
        $this->getPreorderHtmlForList = $getPreorderHtmlForList;
    }

    public function afterToHtml(ListProduct $subject, string $resultHtml): string
    {
        if ($collection = $subject->getLoadedProductCollection()) {
            $resultHtml .= $this->getPreorderHtmlForList->get($subject, $collection->getItems());
        }

        return $resultHtml;
    }
}
