define([
    "jquery",
    "uiRegistry",
    "Magento_Ui/js/modal/modal"
], function ($, registry) {

    $.widget('mage.amPinbar', {
        options: {
        },

        _create: function () {
            this.ampinbarPin = $('#ampinbar-pin');
            this.ampinbarBar = $('#ampinbar-bar');

            this.ampinbarPin.click(function(){ this.addPin(); }.bind(this));

            $.each(this.ampinbarBar.find('.delete'), function(i, btnDel) {
                this.deletePin(btnDel);
            }.bind(this));

            $.each(this.ampinbarBar.find('.rename'), function(i, btnName) {
                this.renamePin(btnName);
            }.bind(this));

            $.each(this.ampinbarBar.find('.title-input'), function(i, inp) {
                this.saveNewTitle(inp);
            }.bind(this));

            this.addEventsForReload();

        },

        addEventsForReload: function() {
            if (document.ampinbarAlreadyPin) {
                $('#ampinbar-pin').addClass('attached');
            } else if ($('#ampinbar_sourcename').length && $('#ampinbar_sourcename')[0].value) {
                if (typeof(registry.events) != "undefined") {
                    registry.events.wait([$('#ampinbar_sourcename')[0].value], {apply:function(hz, elements){
                        registry.storage.data.get($('#ampinbar_sourcename')[0].value).on('reloaded', function(){
                            for (var value of registry.storage.data.values()) {
                                if (value.index == 'bookmarks') {
                                    this.checkBookmarks(value);
                                }
                            }
                        }.bind(this));
                    }.bind(this)});
                } else {
                    registry.get($('#ampinbar_sourcename')[0].value, function(component) {
                        component.on('reloaded', function(){
                            var value = registry.get('index = bookmarks');
                            if (value) {
                                this.checkBookmarks(value);
                            }
                        }.bind(this));
                    }.bind(this));
                }
            }
        },

        checkBookmarks: function(value) {
            var bookmark = JSON.stringify({'current' : value.current});
            var ampinbar = document.ampinbarbookmark;
            for (var i = 0; i < ampinbar.length; i++) {
                var decodePin = JSON.parse(ampinbar[i]);
                var pinForCompare = JSON.stringify(decodePin);
                if (bookmark === pinForCompare) {
                    $('#ampinbar-pin').addClass('attached');
                    return;
                } else {
                    $('#ampinbar-pin').removeClass('attached');
                }
            }
        },

        addPin: function()
        {
            if (!this.ampinbarPin.hasClass('attached')) {

                var bookmark = {};
                var namespace = '';
                var sourcename = '';

                if (typeof(registry.storage) != "undefined") {
                    for (var value of registry.storage.data.values())
                    {
                        if (value.index == 'bookmarks') {
                            this.addSourceToInput(value);
                        }
                    }
                } else {
                    var value = registry.get('index = bookmarks');
                    if (typeof(value) != "undefined") {
                        sourcename = value.source.name;
                        var name = value.name.split('.');
                        if (name[0]) {
                            namespace = name[0];
                        }
                        bookmark = JSON.stringify({'current': value.current});
                        if (!$('#ampinbar_sourcename').length) {
                            var input = '<input type="hidden" id="ampinbar_sourcename" value="' + sourcename + '"/>';
                            this.ampinbarBar.append(input);
                        }
                        if (!document.ampinbarbookmark) {
                            document.ampinbarbookmark = [];
                        }
                        document.ampinbarbookmark.push(bookmark);
                        this.addEventsForReload();
                    }
                }

                this.ampinbarPin.addClass('ampinbar-loading');
                $.ajax({
                    url     : this.options.indexUrl,
                    type    : 'POST',
                    dataType: 'json',
                    data    : {
                        common     : this.options.params,
                        bookmark   : bookmark,
                        sourcename : sourcename,
                        namespace  : namespace
                    }
                }).done($.proxy(function(response) {
                    this.ampinbarPin.addClass('attached');
                    this.ampinbarPin.removeClass('ampinbar-loading');
                    this.ampinbarBar.show();
                    var divTab = $(this.ampinbarPin.find('.tab')[0]).clone(true);
                    var responseTxt = response;
                    var titleText = responseTxt.title;
                    divTab.attr('id',responseTxt.pin_id);
                    divTab.find('.title-span')[0].value = titleText;
                    divTab.find('.title-input')[0].value = titleText;
                    divTab.find('a')[0].href = responseTxt.url;
                    divTab.find('a')[0].title = titleText;
                    this.ampinbarBar.append(divTab);

                    if (!$('#ampinbar_path').length) {
                        var input = '<input type="hidden" id="ampinbar_path" value="' + responseTxt.path + '"/>';
                        this.ampinbarBar.append(input);
                    }

                    this.deletePin(divTab.find('.delete')[0]);
                    this.renamePin(divTab.find('.rename')[0]);
                    this.saveNewTitle(divTab.find('.title-input')[0]);

                    divTab.css('opacity', '0');
                    divTab.show();

                    $(divTab).fadeTo('slow', 1.0 );
                }, this));
            }
        },

        addSourceToInput: function(obj) {
            var sourcename = '';
            var value = obj;
            sourcename = value.source.name;
            var name = value.name.split('.');
            if (name[0]) {
                namespace = name[0];
            }
            bookmark = JSON.stringify({'current' : value.current});
            if (!$('#ampinbar_sourcename').length) {
                var input = '<input type="hidden" id="ampinbar_sourcename" value="' + sourcename + '"/>';
                this.ampinbarBar.append(input);
            }
            if (!document.ampinbarbookmark) {
                document.ampinbarbookmark = [];
            }
            document.ampinbarbookmark.push(bookmark);
            this.addEventsForReload();
        },

        deletePin: function(btnDel)
        {
            $(btnDel).click(function(){
                var tab = $(btnDel).closest('.tab');
                var pinId = tab.attr('id');
                var content = tab.find('.content');
                var loading = tab.find('.tab-loading');
                content.hide();
                loading.show();
                $.ajax({
                    url  : this.options.deleteUrl,
                    type : 'POST',
                    dataType: 'json',
                    data : {pinId : pinId}
                }).done($.proxy(function(response) {
                    tab.remove();
                    if ($('#ampinbar-bar').find('.tab').length == 0) {$('#ampinbar-bar').hide();}
                    var responseTxt = response;
                    if ($('#ampinbar_path').length && $('#ampinbar_path')[0].value == responseTxt.path) {
                        if (!document.ampinbarbookmark) {
                            $('#ampinbar-pin').removeClass('attached');
                        } else {
                            currentBookmark = '';
                            if (typeof(registry.storage) != "undefined") {
                                for (var value of registry.storage.data.values())
                                {
                                    if (value.index == 'bookmarks') {
                                        currentBookmark = JSON.stringify({'current': value.current});
                                    }
                                }
                            } else {
                                var value = registry.get('index = bookmarks');
                                if (value) {
                                    currentBookmark = JSON.stringify({'current': value.current});
                                }
                            }
                            if (currentBookmark === responseTxt.bookmark) {
                                $('#ampinbar-pin').removeClass('attached');
                            }
                        }
                    }
                }));
            }.bind(this));
        },

        renamePin: function(btnName)
        {
            $(btnName).click(function(){
                var tab = $(btnName).closest('.tab');
                tab.find('.title-input').show();
                tab.find('.title-span').hide();
                tab.find('a').hide();
                tab.find('.title-input').focus();
            });
        },

        saveNewTitle: function(input)
        {
            $(input).blur(function(){
                var tab = $(input).closest('.tab');
                var pinId = tab.attr('id');
                var content = tab.find('.content');
                var loading = tab.find('.tab-loading');
                content.hide();
                loading.show();
                $.ajax({
                    url  : this.options.renameUrl,
                    type : 'post',
                    data : {pinId : pinId, title: input.value}
                }).done($.proxy(function() {
                    content.show();
                    loading.hide();
                    tab.find('.title-input').hide();
                    tab.find('.title-span')[0].value = input.value;
                    tab.find('a')[0].title = input.value;
                    tab.find('.title-span').show();
                    tab.find('a').show();
                }));
            }.bind(this));
        }
    });

    return $.mage.amPinbar;
});
