<?php

namespace Amasty\PinBar\Setup;

use Magento\Framework\Setup\InstallSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;

class InstallSchema implements InstallSchemaInterface
{
    public function install(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $installer = $setup;

        $installer->startSetup();

        /**
         * Create table 'amasty_ampinbar'
         */

        $table = $installer->getConnection()
            ->newTable($installer->getTable('amasty_ampinbar'))
            ->addColumn(
                'pin_id',
                \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                null,
                ['identity' => true, 'unsigned' => true, 'nullable' => false, 'primary' => true],
                'Pin Id'
            )
            ->addColumn(
                'user_id',
                \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                null,
                ['unsigned' => true, 'nullable' => false],
                'User Id'
            )
            ->addColumn(
                'path',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                null,
                ['nullable' => false],
                'Path'
            )
            ->addColumn(
                'title',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                null,
                ['nullable' => false],
                'Title Tab'
            )
            ->addForeignKey(
                $installer->getFkName(
                    'amasty_ampinbar',
                    'user_id',
                    'admin_user',
                    'user_id'
                ),
                'user_id',
                $installer->getTable('admin_user'),
                'user_id',
                \Magento\Framework\DB\Ddl\Table::ACTION_CASCADE
            )
            ->setComment('Amasty Bookmarks Bar Table');
        $installer->getConnection()->createTable($table);

        /**
         * Create table 'amasty_ampinbar_session_data'
         */

        $table = $installer->getConnection()
            ->newTable($installer->getTable('amasty_ampinbar_bookmark'))
            ->addColumn(
                'pin_id',
                \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                null,
                ['unsigned' => true, 'nullable' => false],
                'Pin Id'
            )
            ->addColumn(
                'bookmark',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                null,
                ['unsigned' => true, 'nullable' => false],
                'Bookmark Data'
            )
            ->addColumn(
                'namespace',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                null,
                ['unsigned' => true, 'nullable' => false],
                'Namespace Grid'
            )
            ->addColumn(
                'source_name',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                null,
                ['unsigned' => true, 'nullable' => false],
                'Source Name'
            )
            ->addForeignKey(
                $installer->getFkName(
                    'amasty_ampinbar_bookmark',
                    'pin_id',
                    'amasty_ampinbar',
                    'pin_id'
                ),
                'pin_id',
                $installer->getTable('amasty_ampinbar'),
                'pin_id',
                \Magento\Framework\DB\Ddl\Table::ACTION_CASCADE
            )
            ->setComment('Amasty Bookmarks Bar Grid Data Table');
        $installer->getConnection()->createTable($table);

        $installer->endSetup();
    }
}
