<?php

namespace Amasty\PinBar\Observer\Admin;

use Magento\Framework\Event\ObserverInterface;

class SaveBookmark implements ObserverInterface
{
    /**
     * @var \Amasty\PinBar\Helper\Data
     */
    protected $pinbarHelper;

    /**
     * @var \Magento\Ui\Model\Bookmark
     */
    protected $bookmarkModel;

    /**
     * @var \Amasty\PinBar\Model\Bookmark
     */
    protected $amastyBookmarkModel;

    public function __construct(
        \Amasty\PinBar\Helper\Data $pinbarHelper,
        \Magento\Ui\Model\Bookmark $bookmarkModel,
        \Amasty\PinBar\Model\Pinbar $pinbarModel,
        \Amasty\PinBar\Model\Bookmark $amastyBookmarkModel
    )
    {
        $this->pinbarHelper = $pinbarHelper;
        $this->bookmarkModel = $bookmarkModel;
        $this->pinbarModel = $pinbarModel;
        $this->amastyBookmarkModel = $amastyBookmarkModel;
    }

    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        if($this->pinbarHelper->moduleEnabled()) {
            $request = $observer->getRequest();
            if ($pinId = $request->getParam('pinId')) {
                $amastyBookmarkModel = $this->amastyBookmarkModel->load($pinId);
                if ($amastyBookmarkModel) {
                    $namespace = $amastyBookmarkModel->getNamespace();
                    $bookmarkCollection = $this->bookmarkModel->getCollection();
                    $bookmarkCollection->addFieldToFilter('namespace', array('like' => $namespace));
                    $bookmarkCollection->addFieldToFilter('identifier', array('like' => 'current'));
                    if ($bookmarkCollection->getSize()) {
                        foreach ($bookmarkCollection as $model) {
                            $model->setConfig($amastyBookmarkModel->getBookmark());
                            $model->save();
                        }
                    }
                }
            }
        }
    }
}
