<?php

namespace Amasty\PinBar\Observer\Admin;

use Magento\Framework\Event\ObserverInterface;

class AddPinBlock implements ObserverInterface
{
    /**
     * @var \Amasty\PinBar\Helper\Data
     */
    protected $pinbarHelper;

    /**
     * @var \Magento\Framework\View\LayoutInterface
     */
    protected $_layout;

    public function __construct(
        \Amasty\PinBar\Helper\Data $pinbarHelper,
        \Magento\Framework\View\LayoutInterface $layout
    )
    {
        $this->pinbarHelper = $pinbarHelper;
        $this->_layout = $layout;
    }

    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        if($this->pinbarHelper->moduleEnabled()) {
            $block = $observer->getLayout()->getBlock($observer->getElementName());
            if ($block instanceof \Magento\Theme\Block\Html\Title)
            {
                $transport = $observer->getTransport();

                $html = $transport->getOutput() .
                    $this->_layout->createBlock('Amasty\PinBar\Block\Adminhtml\Pin')->toHtml();
                $transport->setOutput($html);
            }
        }
    }
}
