<?php

namespace Amasty\PinBar\Helper;

class Data extends \Magento\Framework\App\Helper\AbstractHelper
{

    CONST ENABLE = 'ampinbar/general/enable';
    CONST SHARED = 'ampinbar/general/shared';

    /**
     * @var \Amasty\PinBar\Model\Pinbar
     */
    protected $_pinbarModel;

    /**
     * @var \Magento\Framework\View\LayoutInterface
     */
    protected $_layout;

    /**
     * @var \Magento\Backend\Model\Auth\Session
     */
    protected $backendAuthSession;

    /**
     * @var \Magento\Ui\Model\Bookmark
     */
    protected $bookmarkModel;

    /**
     * @var \Magento\Framework\Json\DecoderInterface
     */
    protected $jsonDecoder;

    /**
     * @var \Amasty\Base\Model\Serializer
     */
    private $serializer;

    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        \Amasty\PinBar\Model\Pinbar $pinbarModel,
        \Magento\Framework\View\LayoutInterface $layout,
        \Magento\Backend\Model\Auth\Session $backendAuthSession,
        \Magento\Ui\Model\Bookmark $bookmarkModel,
        \Magento\Framework\Json\DecoderInterface $jsonDecoder,
        \Amasty\Base\Model\Serializer $serializer
    ) {
        parent::__construct($context);
        $this->_pinbarModel = $pinbarModel;
        $this->_layout = $layout;
        $this->backendAuthSession = $backendAuthSession;
        $this->bookmarkModel = $bookmarkModel;
        $this->jsonDecoder = $jsonDecoder;
        $this->serializer = $serializer;
    }

    public function moduleEnabled() {
        return $this->scopeConfig->getValue(self::ENABLE);
    }

    public function sharedPins() {
        return $this->scopeConfig->getValue(self::SHARED);
    }

    public function getParamsEncode() {
        $request = $this->_getRequest();
        $params = array();
        $params['params'] = $request->getParams();
        if (array_key_exists('key', $params['params'])) {
            unset($params['params']['key']);
        }
        $params['full_action_name'] = $request->getFullActionName('/');

        if ($block = $this->_layout->getBlock('page.title')) {
            $params['title'] = $block->escapeHtml($block->getPageTitle());
        } else {
            $params['title'] = '';
        }


        return base64_encode($this->serializer->serialize($params));
    }

    public function pinAlreadyAttached() {
        $attached = false;
        $request = $this->_getRequest();
        $pinId = $request->getParam('pinId');
        if ($pinId) {
            $pinCollection = $this->_pinbarModel->getCollection()
                ->addFieldToFilter('pin_id', array('eq' => $pinId));
            if (!$this->sharedPins()) {
                $userId = $this->backendAuthSession->getUser()->getUserId();
                $pinCollection->addFieldToFilter('user_id', $userId);
            }
            if ($pinCollection->getSize()) {
                $attached = true;
            }
        }

        return $attached;
    }
}
