<?php
namespace Amasty\PinBar\Controller\Adminhtml\Pinbar;

class Index extends \Amasty\PinBar\Controller\Adminhtml\Pinbar
{
    /**
     * @var \Amasty\Base\Model\Serializer
     */
    private $serializer;

    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Amasty\PinBar\Model\Pinbar $pinbarModel,
        \Amasty\PinBar\Model\Bookmark $bookmarkModel,
        \Magento\Framework\Json\Helper\Data $jsonHelper,
        \Magento\Backend\Model\Auth\Session $backendAuthSession,
        \Amasty\Base\Model\Serializer $serializer
    ) {
        $this->serializer = $serializer;
        parent::__construct($context, $pinbarModel, $bookmarkModel, $jsonHelper, $backendAuthSession);
    }

    public function execute()
    {
        $request = $this->getRequest();
        $params = $request->getParams();

        $common = $this->serializer->unserialize(base64_decode($params['common']));
        if (array_key_exists('full_action_name', $common)) {
            $url = $common['full_action_name'];
            foreach ($common['params'] as $key => $value) {
                $url .= '/' . $key . '/' . $value;
            }
        } else {
            return 'no data';
        }

        $pinModel = $this->_pinbarModel;
        $userId = $this->backendAuthSession->getUser()->getUserId();
        $pinModel->setUserId($userId);
        $pinModel->setPath($url);
        $pinModel->setTitle($common['title']);
        $pinModel->save();

        $pinId = $pinModel->getId();

        if (array_key_exists('bookmark', $params)) {
            $bookmarkModel = $this->_bookmarkModel;
            $bookmarkModel->setPinId($pinId);
            $bookmarkModel->setBookmark($params['bookmark']);
            $bookmarkModel->setNamespace(isset($params['namespace']) ? $params['namespace'] : '');
            $bookmarkModel->setSourceName(isset($params['sourcename']) ? $params['sourcename'] : '');
            $bookmarkModel->save();
        }

        $result = array(
            'pin_id' => $pinId,
            'title'  => $common['title'],
            'url'    => $this->getUrl($url, array('pinId' => $pinId)),
            'path'   => $url
        );

        $this->getResponse()->setBody($this->jsonHelper->jsonEncode($result));

    }
}
