<?php
namespace Amasty\PinBar\Block\Adminhtml;

class Bar extends \Magento\Backend\Block\Template
{
    /**
     * @var \Amasty\PinBar\Helper\Data
     */
    protected $pinbarHelper;

    /**
     * @var \Amasty\PinBar\Model\Pinbar
     */
    protected $pinbarModel;

    /**
     * @var \Magento\Backend\Model\Auth\Session
     */
    protected $backendAuthSession;

    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Amasty\PinBar\Helper\Data $pinbarHelper,
        \Amasty\PinBar\Model\Pinbar $pinbarModel,
        \Magento\Backend\Model\Auth\Session $backendAuthSession
    ) {
        parent::__construct($context);
        $this->setTemplate('Amasty_PinBar::bar.phtml');

        $this->pinbarHelper = $pinbarHelper;
        $this->pinbarModel = $pinbarModel;
        $this->backendAuthSession = $backendAuthSession;
    }

    public function getModuleEnabled() {
        return $this->pinbarHelper->moduleEnabled();
    }

    public function visibleBar() {
        if ($this->getPinBarCollection()->getSize()) {
            return true;
        } else {
            return false;
        }
    }

    public function getPinBarCollection() {
        $pinCollection = $this->pinbarModel->getCollection();
        if (!$this->pinbarHelper->sharedPins()) {
            $userId = $this->backendAuthSession->getUser()->getUserId();
            $pinCollection->addFieldToFilter('user_id', $userId);
        }
        return $pinCollection;
    }

    public function getDataPined() {
        $request = $this->_request;
        $fullActionName = $request->getFullActionName('/');
        $pinCollection = $this->getPinBarCollection()->addFieldToFilter('path', array('like' => $fullActionName));
        $pinCollection->getSelect()
            ->joinLeft(
                array('bookmark' => $pinCollection->getTable('amasty_ampinbar_bookmark')),
                'bookmark.pin_id = main_table.pin_id'
            );
        $result = array();
        if ($pinCollection->getSize()) {
            foreach ($pinCollection as $model) {
                if ($model->getSourceName()) {
                    if (!array_key_exists('source_name', $result)) {
                        $result['source_name'] = $model->getSourceName();
                        $result['path'] = $model->getPath();
                    }
                } else {
                    $result['already_pin'] = true;
                    $result['path'] = $model->getPath();
                    break;
                }

                if (!array_key_exists('bookmarks', $result)) {
                    $result['bookmarks'] = array();
                }
                $result['bookmarks'][] = $model->getBookmark();
            }
        }
        return $result;
    }
}
