<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Extended Order Grid for Magento 2
 */

namespace Amasty\Ogrid\Ui\Component;

class ExportButton extends \Magento\Ui\Component\ExportButton
{
    /**
     * Change url on export button
     *
     * @return void
     */
    public function prepare()
    {
        $config = $this->getData('config');
        if (isset($config['options'])) {
            $options = [];
            foreach ($config['options'] as $option) {
                switch ($option['value']) {
                    case 'csv':
                        $option['url'] = 'amasty_ogrid/export/gridToCsv';
                        break;

                    case 'xml':
                        $option['url'] = 'amasty_ogrid/export/gridToXml';
                        break;
                }
                $options[] = $option;
            }
            $config['options'] = $options;
        }
        $this->setData('config', $config);
        parent::prepare();
    }
}
