<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Extended Order Grid for Magento 2
 */

namespace Amasty\Ogrid\Plugin\Ui\Model;

class Reader extends AbstractReader
{
    /**
     * Added settings for order grid on magento 2.2.x
     *
     * @param \Magento\Ui\Config\Reader $subject
     * @param array $result
     *
     * @return array
     */
    public function afterRead(
        \Magento\Ui\Config\Reader $subject,
        $result
    ) {
        if (isset($result['children']['sales_order_columns'])) {
            $result['children'] = $this->addAmastySettings($result['children']);
        }

        return $result;
    }
}
