<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Extended Order Grid for Magento 2
 */

namespace Amasty\Ogrid\Model;

use Amasty\Ogrid\Helper\Data;
use Magento\InventorySalesAdminUi\Model\GetSalableQuantityDataBySku;
use Magento\Sales\Api\Data\OrderItemInterface;

class SalableQuantity
{
    /**
     * @var GetSalableQuantityDataBySku
     */
    private $getSalableQuantityDataBySku;

    public function __construct(
        GetSalableQuantityDataBySku $getSalableQuantityDataBySku
    ) {
        $this->getSalableQuantityDataBySku = $getSalableQuantityDataBySku;
    }

    public function modifyData(array $data): array
    {
        $itemsSkuSaleableQtyData = [];
        $dataItems = &$data['items'];

        foreach ($dataItems as &$item) {
            $orderItems = &$item['amasty_ogrid_items_ordered'];

            foreach ($orderItems as &$orderItem) {
                $sku = $orderItem[Data::OGRID_PRODUCT_SKU_COLUMN] ?? $orderItem[OrderItemInterface::SKU];

                if (!isset($itemsSkuSaleableQtyData[$sku])) {
                    try {
                        $salableQuantityData = $this->getSalableQuantityDataBySku->execute($sku);
                        $salableQuantityData = array_map(function ($salableQuantity) {
                            return sprintf('%s : %s', $salableQuantity['stock_name'], $salableQuantity['qty']);
                        }, $salableQuantityData);

                        $itemsSkuSaleableQtyData[$sku] = implode(
                            "; \r\n",
                            $salableQuantityData
                        );
                    } catch (\Throwable $e) {
                        $itemsSkuSaleableQtyData[$sku] = [];
                    }
                }

                $orderItem['amasty_ogrid_product_salable_quantity'] = $itemsSkuSaleableQtyData[$sku];
            }
        }

        return $data;
    }
}
