<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package XML Google® Sitemap for Magento 2
 */

namespace Amasty\XmlSitemap\Model\Sitemap\Hreflang\UrlProvider;

use Magento\CatalogUrlRewrite\Model\ProductUrlRewriteGenerator;
use Magento\UrlRewrite\Model\ResourceModel\UrlRewriteCollectionFactory;
use Magento\UrlRewrite\Model\UrlRewrite;

class RewriteUrlProvider implements UrlProviderInterface
{
    /**
     * @var UrlRewriteCollectionFactory
     */
    private $urlCollectionFactory;

    /**
     * @var GetStoreBaseUrl
     */
    private $getStoreBaseUrl;

    public function __construct(
        UrlRewriteCollectionFactory $urlCollectionFactory,
        GetStoreBaseUrl $getStoreBaseUrl
    ) {
        $this->urlCollectionFactory = $urlCollectionFactory;
        $this->getStoreBaseUrl = $getStoreBaseUrl;
    }

    public function execute(array $storeIds, string $entityType, array $entityIds): array
    {
        $collection = $this->urlCollectionFactory->create();

        $collection->addFieldToFilter('is_autogenerated', ['eq' => 1]);
        $collection->addFieldToFilter('entity_type', ['eq' => $entityType]);
        $collection->addFieldToFilter('entity_id', ['in' => $entityIds]);
        $collection->addStoreFilter($storeIds);

        if ($entityType === ProductUrlRewriteGenerator::ENTITY_TYPE) {
            $collection->addFieldToFilter('target_path', ['nlike' => '%category%']);
        }

        $urls = array_map(function (UrlRewrite $rewrite) {
            return [
                'entity_id' => (int) $rewrite->getEntityId(),
                'store_id' => (int) $rewrite->getStoreId(),
                'url' => $this->getRewriteUrl($rewrite)
            ];
        }, $collection->getItems());

        return $urls;
    }

    public function getRewriteUrl(UrlRewrite $urlRewrite): string
    {
        $url = $this->getStoreBaseUrl->execute((int) $urlRewrite->getStoreId());
        $url .= ltrim($urlRewrite['request_path'], '/');
        return $url;
    }
}
