<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Generate and Import Coupons for Magento 2
 */

namespace Amasty\Xcoupon\Plugin\SalesRule\ResourceModel;

class Coupon
{
    /**
     * @param \Magento\SalesRule\Model\ResourceModel\Coupon $subject
     * @param \Magento\SalesRule\Model\Rule $rule
     *
     * @return array
     */
    public function beforeUpdateSpecificCoupons(
        \Magento\SalesRule\Model\ResourceModel\Coupon $subject,
        \Magento\SalesRule\Model\Rule $rule
    ) {
        $rule->setOrigData('uses_per_customer', $rule->getUsesPerCustomer());
        $rule->setOrigData('uses_per_coupon', $rule->getUsesPerCoupon());

        return [$rule];
    }
}
