<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Generate and Import Coupons for Magento 2
 */

namespace Amasty\Xcoupon\Model\ResourceModel\Report\Usage\Grid;

use Magento\Framework\Data\Collection\Db\FetchStrategyInterface as FetchStrategy;
use Magento\Framework\Data\Collection\EntityFactoryInterface as EntityFactory;
use Magento\Framework\Event\ManagerInterface as EventManager;
use Psr\Log\LoggerInterface as Logger;

class Collection extends \Magento\Sales\Model\ResourceModel\Order\Grid\Collection
{
    public const ID_FIELD_NAME = 'id';

    public function __construct(
        EntityFactory $entityFactory,
        Logger $logger,
        FetchStrategy $fetchStrategy,
        EventManager $eventManager
    ) {
        parent::__construct(
            $entityFactory,
            $logger,
            $fetchStrategy,
            $eventManager
        );
        $this->_setIdFieldName(self::ID_FIELD_NAME);
    }

    protected function _initSelect()
    {
        parent::_initSelect();

        $this->join(
            ['order' => 'sales_order'],
            'order.entity_id=main_table.entity_id',
            []
        );

        $this->join(
            ['coupon' => 'salesrule_coupon'],
            "order.coupon_code LIKE CONCAT('%', coupon.code ,',%') 
            OR order.coupon_code LIKE CONCAT('%', coupon.code)",
            ['coupon.code']
        );

        $this->join(
            ['rule' => 'salesrule'],
            'rule.rule_id=coupon.rule_id',
            ['rule.name']
        );

        $this->getSelect()->joinLeft(
            ['track' => $this->getTable('sales_shipment_track')],
            'track.order_id=main_table.entity_id',
            ['track_number' => 'GROUP_CONCAT(track.track_number)']
        );

        $this->getSelect()->group(['main_table.entity_id', 'coupon.code']);
    }

    /**
     * @return $this
     */
    protected function _afterLoad()
    {
        parent::_afterLoad();
        $this->setIdForItems();

        return $this;
    }

    /**
     * Adding fake id column to prevent collection exception
     * when collection trying to add item with same value of id field
     */
    private function setIdForItems(): void
    {
        $i = 1;
        foreach ($this->getItems() as $item) {
            $item->setData(self::ID_FIELD_NAME, $i++);
        }
    }
}
