<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Generate and Import Coupons for Magento 2
 */

namespace Amasty\Xcoupon\Controller\Adminhtml\Sales\Rule;

use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\ResultInterface;

class SaveCoupon extends EditCoupon
{
    /**
     * @return ResponseInterface|ResultInterface|void
     */
    public function execute()
    {
        $model = null;
        if ($this->getRequest()->getPostValue()) {
            try {
                $data = $this->getRequest()->getPostValue();
                if ($id = $this->getRequest()->getParam('coupon_id')) {
                    $model = $this->couponRepository->getById($id);
                    $model->addData(
                        [
                            'code' => $data['code'],
                            'usage_limit' => $data['usage_limit'],
                            'usage_per_customer' => $data['usage_per_customer']
                        ]
                    );
                    $this->resourceModel->save($model);

                    $this->messageManager->addSuccessMessage(__('The coupon is saved.'));

                    if ($this->getRequest()->getParam('back')) {
                        return $this->_redirect('*/*/editCoupon', ['id' => $id, '0' => $model->getRuleId()]);
                    }

                    if ($model->getRuleId()) {
                        return $this->_redirect('sales_rule/promo_quote/edit', ['id' => $model->getRuleId()]);
                    } else {
                        return $this->_redirect('sales_rule/promo_quote/index');
                    }
                }
                $this->messageManager->addErrorMessage(__('This coupon no longer exists.'));
            } catch (\Exception $e) {
                $this->messageManager->addErrorMessage(
                    __('Something went wrong while saving the coupon data.') . $e->getMessage()
                );
            }
        }

        if ($this->getRequest()->getParam('back') && $model) {
            return $this->_redirect('*/*/editCoupon', ['id' => $model->getCouponId()]);
        }

        if ($model && $model->getRuleId()) {
            return $this->_redirect('sales_rule/promo_quote/edit', ['id' => $model->getRuleId()]);
        } else {
            return $this->_redirect('sales_rule/promo_quote/index');
        }
    }
}
