<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Generate and Import Coupons for Magento 2
 */

namespace Amasty\Xcoupon\Controller\Adminhtml\Sales\Rule;

use Magento\Framework\Controller\ResultFactory;

class EditCoupon extends \Magento\SalesRule\Controller\Adminhtml\Promo\Quote
{
    public const CURRENT_COUPON_MODEL = 'amasty_xcoupon_current_coupon';
    /**
     * @var \Magento\SalesRule\Model\CouponRepository
     */
    protected $couponRepository;
    /**
     * @var \Magento\SalesRule\Model\Spi\CouponResourceInterface
     */
    protected $resourceModel;

    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\Registry $coreRegistry,
        \Magento\Framework\App\Response\Http\FileFactory $fileFactory,
        \Magento\Framework\Stdlib\DateTime\Filter\Date $dateFilter,
        \Magento\SalesRule\Model\CouponRepository $couponRepository,
        \Magento\SalesRule\Model\Spi\CouponResourceInterface $resourceModel
    ) {
        parent::__construct($context, $coreRegistry, $fileFactory, $dateFilter);
        $this->couponRepository = $couponRepository;
        $this->resourceModel = $resourceModel;
    }

    public function execute()
    {
        $id = $this->getRequest()->getParam('id');
        if ($id) {
            try {
                $model = $this->couponRepository->getById($id);
            } catch (\Magento\Framework\Exception\NoSuchEntityException $exception) {
                $this->messageManager->addErrorMessage(__('This coupon no longer exists.'));
                return $this->redirectDependOnModel();
            }
        } else {
            $this->messageManager->addErrorMessage(__('This coupon no longer exists.'));
            return $this->redirectDependOnModel();
        }

        $this->_coreRegistry->register(self::CURRENT_COUPON_MODEL, $model);

        $this->_initAction();

        $this->_view->getPage()->getConfig()->getTitle()->prepend(
            __('Edit Coupon #') . $model->getId()
        );

        /** @var \Magento\Backend\Model\View\Result\Page $resultPage */
        $result = $this->resultFactory->create(ResultFactory::TYPE_PAGE);
        $result->renderResult($this->getResponse());
    }

    private function redirectDependOnModel()
    {
        $resultRedirect = $this->resultRedirectFactory->create();

        $model = $this->_coreRegistry->registry(\Magento\SalesRule\Model\RegistryConstants::CURRENT_SALES_RULE);
        if ($model && $model->getId()) {
            return $resultRedirect->setPath('sales_rule/promo_quote/edit', ['id' =>  $model->getId()]);
        } else {
            return $resultRedirect->setPath('sales_rule/promo_quote/index');
        }
    }
}
