<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Generate and Import Coupons for Magento 2
 */

namespace Amasty\Xcoupon\Block\Adminhtml\Promo\Quote\Edit\Tab\Coupons;

use Magento\Backend\Block\Template\Context;
use Magento\Backend\Block\Widget\Form\Generic;
use Magento\Config\Model\Config\Source\Yesno;
use Magento\Framework\Data\FormFactory;
use Magento\Framework\Registry;
use Magento\SalesRule\Model\RegistryConstants;

class Generate extends Generic
{
    /** @var Yesno  */
    protected $yesno;

    public function __construct(
        Context $context,
        Registry $registry,
        FormFactory $formFactory,
        Yesno $yesno,
        array $data = []
    ) {
        $this->yesno = $yesno;
        parent::__construct($context, $registry, $formFactory, $data);
    }

    /*
     * @return $this
     * @SuppressWarnings(PHPMD.ExcessiveMethodLength)
     */
    protected function _prepareForm()
    {
        $model = $this->_coreRegistry->registry(RegistryConstants::CURRENT_SALES_RULE);
        $ruleId = $model->getId();

        if (!$ruleId) {
            return parent::_prepareForm();
        }

        /** @var \Magento\Framework\Data\Form $form */
        $form = $this->_formFactory->create();

        $fieldset = $form->addFieldset('amasty_generate_fieldset', [
            'legend' => 'Generate Coupons by Template',
            'class' => 'amasty-xcoupon-expand-fieldset'
        ]);

        $fieldset->addField(
            'amasty_xcoupon_qty',
            'text',
            [
                'name' => 'qty',
                'label' => __('Coupon Qty'),
                'title' => __('Coupon Qty'),
                'required' => true,
                'class' => 'validate-digits validate-greater-than-zero'
            ]
        );

        $fieldset->addField(
            'amasty_xcoupon_delete_existing_coupons',
            'select',
            [
                'name' => 'clean',
                'label' => __('Delete Existing Coupons'),
                'title' => __('Delete Existing Coupons'),
                'values' => $this->yesno->toOptionArray()
            ]
        );

        $fieldset->addField('amasty_xcoupon_generate_pattern', 'text', [
            'label' => __('Template'),
            'required' => true,
            'name' => 'pattern',
            'note' => __('<b>L</b> - letter, <b>D</b> - digit<br/>e.g. PROMO_LLDDD results in PROMO_DF627')
        ]);

        $gridBlock = $this->getLayout()->getBlock('promo_quote_edit_tab_coupons_grid');
        $gridBlockJsObject = '';
        if ($gridBlock) {
            $gridBlockJsObject = $gridBlock->getJsObjectName();
        }
        $idPrefix = $form->getHtmlIdPrefix();

        $fieldset->addField(
            'amasty_xcoupon_generate_button',
            'note',
            [
                'text' => $this->getButtonHtml(
                    __('Generate'),
                    "amastyXcouponGenerate({$ruleId}, '{$this->getGenerateUrl()}', '{$gridBlockJsObject}')",
                    'generate'
                )
            ]
        );

        $this->setForm($form);

        return parent::_prepareForm();
    }

    public function getGenerateUrl()
    {
        return $this->getUrl('amasty_xcoupon/generate/run');
    }

    public function getFormHtml(): string
    {
        $model = $this->_coreRegistry->registry(RegistryConstants::CURRENT_SALES_RULE);
        $ruleId = $model->getId();

        if (!$ruleId || !is_object($this->getForm())) {
            return '';
        } else {
            return $this->getForm()->getHtml();
        }
    }

    public function toHtml(): string
    {
        $model = $this->_coreRegistry->registry(RegistryConstants::CURRENT_SALES_RULE);
        $ruleId = $model->getId();

        if (!$ruleId) {
            return '';
        }

        return parent::toHtml();
    }
}
