<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Generate and Import Coupons for Magento 2
 */

namespace Amasty\Xcoupon\Block\Adminhtml\Button;

use Magento\Framework\App\RequestInterface;
use Magento\Framework\UrlInterface;
use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;

class Back implements ButtonProviderInterface
{
    /**
     * @var \Magento\Framework\UrlInterface
     */
    private $urlBuilder;

    /**
     * @var \Magento\Framework\App\RequestInterface
     */
    private $request;

    public function __construct(UrlInterface $urlBuilder, RequestInterface $request)
    {
        $this->urlBuilder = $urlBuilder;
        $this->request = $request;
    }

    /**
     * @return array
     */
    public function getButtonData()
    {
        $data = [
            'label' => __('Back'),
            'class' => 'back',
            'on_click' => sprintf("location.href = '%s';", $this->getBackUrl()),
            'sort_order' => 1,
        ];

        return $data;
    }

    /**
     * @return string
     */
    private function getBackUrl()
    {
        // can not create right url because of magento bug in
        // vendor/magento/module-backend/Block/Widget/Grid/Column/Renderer/Action.php:182
        // need $params = array_merge($action['url']['params'], $params);
        return $this->urlBuilder->getUrl('sales_rule/promo_quote/edit', ['id' => $this->request->getParam('0')]);
    }
}
