<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Thank You Page for Magento 2
*/

declare(strict_types=1);

namespace Amasty\ThankYouPage\Model\Config\Types;

use Amasty\ThankYouPage\Api\ConfigCreateAccountInterface;

class CreateAccount extends Custom implements ConfigCreateAccountInterface
{
    /**#@+
     * xpath field parts
     */
    public const FIELD_TITLE = 'title';
    public const FIELD_AUTO_GENERATE_PASSWORD = 'auto_generate_password';
    public const FIELD_SHOW_EMAIL = 'show_email_field';
    public const FIELD_SHOW_TERMS_AND_CONDITIONS = 'show_terms_and_conditions';
    public const FIELD_TERMS_TEXT = 'terms_text';

    /**#@-*/

    /**
     * @return bool
     */
    public function isPasswordAutoGenerated(): bool
    {
        return $this->isSetFlag($this->getGroupPrefix() . self::FIELD_AUTO_GENERATE_PASSWORD);
    }

    /**
     * @return bool
     */
    public function isEmailFieldVisible(): bool
    {
        return $this->isSetFlag($this->getGroupPrefix() . self::FIELD_SHOW_EMAIL);
    }

    /**
     * @return bool
     */
    public function isTermsAndConditionsVisible(): bool
    {
        return $this->isSetFlag($this->getGroupPrefix() . self::FIELD_SHOW_TERMS_AND_CONDITIONS);
    }

    /**
     * @return string|null
     */
    public function getTermsText(): ?string
    {
        return $this->getValue($this->getGroupPrefix() . self::FIELD_TERMS_TEXT);
    }
}
