<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Thank You Page for Magento 2
*/

declare(strict_types=1);

namespace Amasty\ThankYouPage\Block\Onepage\Success\Types\Custom;

use Amasty\ThankYouPage\Block\Onepage\Success\Types\CustomAbstract;

class Custom3 extends CustomAbstract
{
    public const BLOCK_CONFIG_NAME = 'custom3';

    /**
     * Related group name in admin settings
     *
     * @return string
     */
    protected function getGroupPrefix(): string
    {
        return 'block_' . self::BLOCK_CONFIG_NAME;
    }

    /**
     * @return int
     */
    public function getWidth(): int
    {
        return $this->blockConfig->getWidthByBlockId(self::BLOCK_CONFIG_NAME);
    }
}
