<?php

declare(strict_types=1);

namespace Amasty\StorelocatorIndexer\Setup;

use Amasty\StorelocatorIndexer\Model\ResourceModel\LocationProductIndex;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\UninstallInterface;

class Uninstall implements UninstallInterface
{
    /**
     * @param SchemaSetupInterface $setup
     * @param ModuleContextInterface $context
     */
    public function uninstall(SchemaSetupInterface $setup, ModuleContextInterface $context): void
    {
        $setup->getConnection()
            ->dropTable($setup->getTable(LocationProductIndex::TABLE_NAME));
    }
}
