<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2020 Amasty (https://www.amasty.com)
 * @package Amasty_Rules
 */

/**
 * phpcs:ignoreFile
 * @codeCoverageIgnore
 */

require 'products.php';

/** @var \Magento\Catalog\Api\ProductRepositoryInterface $productRepository */
$productRepository = \Magento\TestFramework\Helper\Bootstrap::getObjectManager()
    ->create(\Magento\Catalog\Api\ProductRepositoryInterface::class);

$products = [
    'product' => $productRepository->get('simple'),
    'product2' => $productRepository->get('simple2'),
    'product3' => $productRepository->get('simple3'),
    'product4' => $productRepository->get('simple4'),
];

$requestInfo = new \Magento\Framework\DataObject(['qty' => 1]);

/** @var $cart \Magento\Checkout\Model\Cart */
$cart = \Magento\TestFramework\Helper\Bootstrap::getObjectManager()->create(\Magento\Checkout\Model\Cart::class);

foreach ($products as $product) {
    $cart->addProduct($product, $requestInfo);
}
$cart->save();

/** @var $objectManager \Magento\TestFramework\ObjectManager */
$objectManager = \Magento\TestFramework\Helper\Bootstrap::getObjectManager();
$objectManager->removeSharedInstance(\Magento\Checkout\Model\Session::class);
