<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2020 Amasty (https://www.amasty.com)
 * @package Amasty_Rules
 */

/**
 * phpcs:ignoreFile
 * @codeCoverageIgnore
 */

$objectManager = \Magento\TestFramework\Helper\Bootstrap::getObjectManager();
/** @var Magento\Framework\Registry $registry */
$registry = $objectManager->get(\Magento\Framework\Registry::class);

/** @var \Magento\SalesRule\Model\Rule $salesRule */
$salesRule = $objectManager->create(\Magento\SalesRule\Model\Rule::class);
$salesRule->setData(
    [
        'name' => 'Buy X get Y With 2 Products Get 10 Percent Amount',
        'is_active' => 1,
        'customer_group_ids' => [\Magento\Customer\Model\GroupManagement::NOT_LOGGED_IN_ID],
        'coupon_type' => \Magento\SalesRule\Model\Rule::COUPON_TYPE_NO_COUPON,
        'simple_action' => 'buyxgetn_perc',
        'discount_amount' => 10,
        'discount_step' => 2,
        'stop_rules_processing' => 0,
        'website_ids' => [
            \Magento\TestFramework\Helper\Bootstrap::getObjectManager()->get(
                \Magento\Store\Model\StoreManagerInterface::class
            )->getWebsite()->getId()
        ]
    ]
);
$salesRule->save();
$registry->unregister('Magento/SalesRule/_files/cart_rule_buy_x_get_y_10_percent_discount');
$registry->register('Magento/SalesRule/_files/cart_rule_buy_x_get_y_10_percent_discount', $salesRule->getRuleId());
