<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Special Promo Import Entity by Amasty
 */

namespace Amasty\SpecialPromoImportEntity\Import\SourceOptions;

use Magento\Framework\Data\OptionSourceInterface;

class UseFor implements OptionSourceInterface
{
    public const ALL_PRODUCTS = 0;
    public const SAME_PRODUCTS = 1;

    public function toOptionArray(): array
    {
        $result = [];

        foreach ($this->toArray() as $value => $label) {
            $result[] = ['value' => $value, 'label' => $label];
        }

        return $result;
    }

    public function toArray(): array
    {
        return [
            self::ALL_PRODUCTS => __('All Products in Shopping Cart'),
            self::SAME_PRODUCTS => __('The Same Product in Shopping Cart')
        ];
    }
}
