<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Special Promo Export Entity by Amasty
 */

namespace Amasty\SpecialPromoExportEntity\Export\SourceOptions;

use Magento\Framework\Data\OptionSourceInterface;

class ApplyDiscountTo implements OptionSourceInterface
{
    public const ASC = 'asc';
    public const DESC = 'desc';

    public function toOptionArray(): array
    {
        $result = [];

        foreach ($this->toArray() as $value => $label) {
            $result[] = ['value' => $value, 'label' => $label];
        }

        return $result;
    }

    public function toArray(): array
    {
        return [
            self::ASC => __('Cheapest products'),
            self::DESC => __('Most expensive products')
        ];
    }
}
