<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Special Promotions Rules Duration by Amasty
 */

namespace Amasty\RulesDuration\Ui\Component\Form\Field;

use Magento\Framework\Stdlib\DateTime\TimezoneInterface;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Ui\Component\Form\Field;

class Date extends Field
{
    /**
     * @var TimezoneInterface
     */
    private $timezone;
    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        TimezoneInterface $timezone,
        array $components = [],
        array $data = []
    ) {
        parent::__construct($context, $uiComponentFactory, $components, $data);
        $this->timezone = $timezone;
    }

    public function prepare()
    {
        parent::prepare();

        //unset rule 'validate-date' because magento can't validate date with time
        $config = $this->getData('config');
        $config['options']['timeFormat'] = $this->timezone->getTimeFormat();
        if (isset($config['validation']['validate-date'])) {
            unset($config['validation']['validate-date']);
            $this->setData('config', $config);
        }
    }
}
