<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Special Promotions Rules Duration by Amasty
 */

namespace Amasty\RulesDuration\Setup\Patch\Data;

use Amasty\Rules\Model\ResourceModel\Rule;
use Amasty\Rules\Model\RuleProvider;
use Magento\Framework\App\ProductMetadataInterface;
use Magento\Framework\EntityManager\MetadataPool;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Stdlib\DateTime\Timezone;
use Magento\SalesRule\Api\Data\RuleInterface as SalesRuleInterface;
use Magento\SalesRule\Model\ResourceModel\Rule\CollectionFactory;

class SaveRuleTime implements DataPatchInterface
{
    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    /**
     * @var Rule
     */
    private $ruleResource;

    /**
     * @var MetadataPool
     */
    private $metadataPool;

    /**
     * @var ProductMetadataInterface
     */
    private $productMetadata;

    /**
     * @var RuleProvider
     */
    private $ruleProvider;

    /**
     * @var Timezone
     */
    private $timezone;

    public function __construct(
        CollectionFactory $collectionFactory,
        Rule $ruleResource,
        MetadataPool $metadataPool,
        ProductMetadataInterface $productMetadata,
        RuleProvider $ruleProvider,
        Timezone $timezone
    ) {
        $this->collectionFactory = $collectionFactory;
        $this->ruleResource = $ruleResource;
        $this->metadataPool = $metadataPool;
        $this->productMetadata = $productMetadata;
        $this->ruleProvider = $ruleProvider;
        $this->timezone = $timezone;
    }

    public static function getDependencies(): array
    {
        return [];
    }

    public function getAliases(): array
    {
        return [];
    }

    public function apply(): self
    {
        if ($this->productMetadata->getEdition() === 'Enterprise') {
            return $this;
        }

        $collection = $this->collectionFactory->create();
        $linkField = $this->metadataPool->getMetadata(SalesRuleInterface::class)->getLinkField();

        foreach ($collection->getItems() as $salesRule) {
            $ruleLinkId = (int)$salesRule->getDataByKey($linkField);

            /** @var \Amasty\Rules\Model\Rule $amRule */
            $amRule = $this->ruleProvider->getAmruleByRuleId($ruleLinkId);
            $ruleChanged = false;

            $dateFrom = $salesRule->getData('from_date');
            if ($dateFrom) {
                $amRule->setData('from_datetime', $this->timezone->convertConfigTimeToUtc($dateFrom . ' 00:00:00'));
                $ruleChanged = true;
            }

            $dateTo = $salesRule->getData('to_date');
            if ($dateTo) {
                $amRule->setData('to_datetime', $this->timezone->convertConfigTimeToUtc($dateTo . ' 23:59:00'));
                $ruleChanged = true;
            }

            if ($ruleChanged) {
                if (!$amRule->getData('salesrule_id')) {
                    $amRule->setData('salesrule_id', $ruleLinkId);
                }
                $this->ruleResource->save($amRule);
            }
        }

        return $this;
    }
}
