<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Special Promotions Rules Duration by Amasty
 */

namespace Amasty\RulesDuration\Plugin\SalesRule\Controller\Adminhtml\Promo\Quote\Save;

use Magento\Framework\Stdlib\DateTime\Timezone;
use Magento\SalesRule\Controller\Adminhtml\Promo\Quote\Save;

class ReformatDateFromRequest
{
    /**
     * @var Timezone
     */
    private $timezone;

    public function __construct(
        Timezone $timezone
    ) {
        $this->timezone = $timezone;
    }

    public function beforeExecute(Save $subject): array
    {
        $request = $subject->getRequest();
        $originFromDate = $request->getParam('from_date');
        $originToDate = $request->getParam('to_date');

        if ($originFromDate) {
            $fromDate = new \DateTime($originFromDate);
            $request->setPostValue('from_date', $this->timezone->formatDate($fromDate));
        }

        if ($originToDate) {
            $toDate = new \DateTime($originToDate);
            $request->setPostValue('to_date', $this->timezone->formatDate($toDate));
        }

        $request->setParam('amrule_from_date', $originFromDate);
        $request->setParam('amrule_to_date', $originToDate);

        return [];
    }
}
